/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_DEVICE_HANDLER_H
#define NMN_DEVICE_HANDLER_H

#include <glib-object.h>
#include <nm-device.h>
#include <nm-settings.h>
#include "nmn-nm-data.h"
#include "nmn-item.h"

#define NMN_TYPE_DEVICE_HANDLER            (nmn_device_handler_get_type ())
#define NMN_DEVICE_HANDLER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_DEVICE_HANDLER, NmnDeviceHandler))
#define NMN_DEVICE_HANDLER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_DEVICE_HANDLER, NmnDeviceHandlerClass))
#define NMN_IS_DEVICE_HANDLER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_DEVICE_HANDLER))
#define NMN_IS_DEVICE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_DEVICE_HANDLER))
#define NMN_DEVICE_HANDLER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_DEVICE_HANDLER, NmnDeviceHandlerClass))

#define NMN_DEVICE_HANDLER_NM_DATA "nm-data"
#define NMN_DEVICE_HANDLER_DEVICE "device"

typedef struct {
    GObject parent;
} NmnDeviceHandler;

typedef struct {
    GObjectClass parent;

    /* methods */
    void (*connection_added) (NmnDeviceHandler *self,
                              NMExportedConnection *exported);

    /* signals */
    void (*item_added) (NmnDeviceHandler *self,
                        NmnItem *item);
} NmnDeviceHandlerClass;

GType nmn_device_handler_get_type (void);

void nmn_device_handler_start (NmnDeviceHandler *self);
void nmn_device_handler_add_items (NmnDeviceHandler *self);
NmnNMData *nmn_device_handler_get_nm_data (NmnDeviceHandler *self);
NMDevice *nmn_device_handler_get_device (NmnDeviceHandler *self);

void nmn_device_handler_add_item (NmnDeviceHandler *self,
                                  NmnItem *item);

GSList *nmn_device_handler_get_items (NmnDeviceHandler *self);
GSList *nmn_device_handler_get_connections (NmnDeviceHandler *self);

NmnItem *nmn_device_handler_get_item_for_connection (NmnDeviceHandler *self,
                                                     NMExportedConnection *connection);

void nmn_device_handler_remove_items (NmnDeviceHandler *self);

#endif /* NMN_DEVICE_HANDLER_H */
