# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import pango

import utils
from helper import helper

class PlayInfo(gtk.Label):
    def __init__(self,player):
        super(PlayInfo,self).__init__("")

        self.set_alignment(0,0.5)
        self.set_ellipsize(pango.ELLIPSIZE_END)
        self.set_use_markup(True)
        
        self.set_markup("<span size=\"x-large\"><b>"+_("No playing")+"</b></span>\n\n")
        utils.set_tip(self,_("No playing"))


        player.connect("instant-new-song",self.update)
        helper.connect("changed",self.on_change)
        
        self.song = None
        
    def on_change(self,helper,songs):
        for s in songs:
            if s == self.song:
                self.update(None,s)
                break
        
    def update(self,player,song):
        self.song = song
        tip = song.get_str("title")
        markup = "<span size=\"x-large\"><b>"+song.get_str("title",True)+"</b></span>\n"
        if song.get("artist"):
            tip += " - "+song.get_str("artist")
            markup += "<span size=\"large\"><i>"+song.get_str("artist",True)+"</i></span>"
        markup += "\n"
        if song.get("album"):
            tip += " - "+song.get_str("album")
            markup += "<span size=\"large\">"+song.get_str("album",True)+"</span>"
            
        
        self.set_markup(markup)
        utils.set_tip(self,tip)
        
